require 'div'
require 'nkf'
require 'singleton'
require 'wall'
require 'webrick/cgi'
require 'tofu/tofulet'

module WallDiv
  class WallSession < Div::TofuSession
    WALL = Wall::Grid.get_instance

    def initialize(bartender, hint=nil)
      super(bartender, hint)
      @wall = WALL
      @base = BaseDiv.new(self)
      @current = nil
    end
    attr_reader :login, :wall
    attr_accessor :current

    def do_GET(context)
      update_div(context)
      context.res_header('content-type', 'text/html; charset=euc-jp')
      context.res_body(@base.to_div(context))
    end

    def kconv(str)
      NKF.nkf('-e', str.to_s)
    end
  end

  class BaseDiv < Div::Div
    set_erb('base.erb')

    def initialize(session)
      super(session)
      @grid = GridDiv.new(session)
      @edit = EditDiv.new(session)
    end

    def to_div(context)
      to_html(context)
    end
  end

  class EditDiv < Div::Div
    set_erb('wall_edit.erb')

    def initialize(session)
      super(session)
      @wall = session.wall
    end

    def to_args(param)
      text ,= param['text']
      args = {}
      if text
        args[:text] = text
      end
      args
    end

    def do_update(context, param)
      args = to_args(param)
      return unless args[:text]
      @session.current.text = args[:text]
      @session.current = nil
    rescue
    end
  end

  class GridDiv < Div::Div
    set_erb('wall_grid.erb')

    def initialize(session)
      super(session)
      @wall = session.wall
    end

    def to_args(param)
      x ,= param['x']
      y ,= param['y']
      args = {}
      begin
        args[:x] = x.to_i if x.to_s.size > 0
        args[:y] = y.to_i if y.to_s.size > 0
      rescue
      end
      args
    end

    def make_url(method_name, add_param, context)
      param = make_param(method_name, add_param)
      ary = param.collect do |k, v|
	"#{u(k)}=#{u(v)}"
      end
      %Q!#{action(context)}?#{ary.join(';')}!
    end

    def do_update(context, param)
      args = to_args(param)
      return unless args[:x]
      return unless args[:y]
      @session.current = @wall.grow(args[:x], args[:y])
    rescue
      p $!
    end

    def memo(x, y)
      @wall[x, y]
    end
  end
end

if __FILE__ == $0
  tofu = Tofu::Bartender.new(WallDiv::WallSession)
  DRb.start_service('druby://localhost:12321', WEBrick::CGITofulet.new(tofu))
  # DRb.thread.join
  while true
    gets
    WallDiv::BaseDiv.reload_erb
    WallDiv::GridDiv.reload_erb
  end
end
