require 'koya/koya'
require 'koya/klass'
require 'koya/quoya'

module Wall
  class Grid < Koya::KoyaObject
    def initialize(w = 8, h = 8)
      @grid = Koya::Dict.new
      @width = w
      @height = h
    end
    attr_reader :width, :height

    def grow(x, y)
      transaction do
        @width.times { |n| self[n, y].update }
        @height.times { |n| self[x, n].update }
        memo = self[x, y]
        memo.update
        memo
      end
    end

    def [](x, y)
      transaction do
        addr = "#{x}.#{y}"
        @grid[addr] ||= Memo.new
        @grid[addr]
      end
    end

    def self.get_instance
      store = Koya::VillaStore.new('db_wall.db')
      store.transaction {
        store.root['wall'] = Grid.new unless store.root['wall']
      }
      store.root['wall']
    end
  end

  class Memo < Koya::KoyaObject
    def initialize
      @age = 0
      @text = nil
    end
    attr_reader :age
    attr_reader :text

    def update
      @age += 1
    end

    def text=(str)
      @text = str
      update
      @age = 0 if str.to_s.size == 0
    end

    def to_s
      text
    end
  end
end

