require 'erb'

class TropyUI
  include ERB::Util

  EDIT_FORM_RHTML = <<-EOD
<form action="<%= absolute_url %>" method="post">
<input type="hidden" name="w<%= key %>" value="1">
<textarea cols="60" rows="10" name="msg"><%=h text%></textarea><br><input type="submit" value="Write">
</form>
  EOD

  ERB.new(EDIT_FORM_RHTML).def_method(self, 'edit_form()')

  NAVI_RHTML = <<-EOD
<p id="navi">
  <% if editable? %><a href="?e<%= key%>">Edit</a><% end %>
  <a href="?c">Create</a>
  <a href="<%= absolute_url%>">Random</a>
</p>
  EOD

  ERB.new(NAVI_RHTML).def_method(self, 'navi()')

  READ_MESSAGE_RHTML = <<-EOD
<% body.each do |line| %>
  <p><%=h line%></p>
<% end %>
  EOD
  ERB.new(READ_MESSAGE_RHTML).def_method(self, 'read_message()')

  BASE_RHTML = <<-EOD
Content-type: text/html; charset=Shift_JIS

<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
   "http://www.w3.org/TR/html4/loose.dtd">
<html lang="ja">
<head>
<meta http-equiv="content-type" content="text/html; charset=Shift_JIS">
<meta http-equiv="content-style-type" content="text/css">
<base href="<%= absolute_url%>">
<style type="text/css"><!--
body{font-family:Verdana,sans-serif;margin:2% 20% 10% 20%;color:<%= color%>;background-color:<%= bgcolor%>;}
input{font-family:Verdana,sans-serif;}
#navi{text-align:right;}
p{line-height:150%;}
a{color:gray;background-color:<%= bgcolor %>;text-decoration:none;}
a:hover{text-decoration:underline;color:white;background-color:gray;}
--></style>
<title><%=h title %> - YA-Tropy</title>
</head>
<body>
<%= navi %>
<h1><%=h title%></h1>

<% if @event == :edit %>
<%= edit_form %>
<% elsif @event == :create %>
<%= edit_form %>
<% else %>
<%= read_message %>
<% end %>

</div></body></html>
  EOD

  ERB.new(BASE_RHTML).def_method(self, 'base()')

  ON_ERROR_RHTML = <<-'EOD'
Content-Type: text/html;

<html><head><title>Error</title></head><body><h1>Error</h1><pre>
<%=h "#{$!} (#{$!.class})" %>
<%=h $@.join("\n") %>
</pre>
  EOD

  ERB.new(ON_ERROR_RHTML).def_method(self, 'on_error()')

  def initialize(cgi, db)
    @cgi = cgi
    @db = db
    @leaf = { :key => 0, :title => 'New Page', :text => '', :body => ''}
    @event = nil
  end

  def do_read(key)
    @leaf = @db[key]
    @event = :read
  end

  def do_edit(key)
    @leaf = @db[key]
    @event = :edit
  end

  def do_read_any
    @leaf = @db.any
    @event = :read
  end

  def do_create
    @event = :create
  end

  def do_write(key, text)
    return do_read_any if /^\s*\z/ =~ text

    @leaf = @db.replace(key, text)
    @event = :read
  end

  def do_request
    @cgi.params.each_key do |k|
      if k =~ /^(\d{8})$/
        return do_read($1.to_i)
      elsif k =~ /^e(\d{8})$/
        return do_edit($1.to_i)
      elsif k =~ /^w(\d{8})$/
        text ,= @cgi['msg']
        return do_write($1.to_i, text.to_s)
      elsif k =~ /^c$/
        return do_create
      end
    end
    do_read_any
  end

  def editable?
    @event == :read
  end

  def absolute_url
    port = @cgi.server_port
    if port.nil? || port  == 80
      port = '' 
    else
      port = ":#{@cgi.server_port}"
    end
    
    "http://#{@cgi.server_name}#{port}#{@cgi.script_name}"
  end

  def build_ui
    base
  end

  def title
    @leaf[:title]
  end

  def key
    sprintf("%08d", @leaf[:key])
  end

  def body
    @leaf[:body]
  end

  def text
    @leaf[:text]
  end

  def bgcolor
    k = @leaf[:key]
    r = 255 - (k & 0b11111)
    g = 255 - ((k >> 5) & 0b11111)
    b = 255 - ((k >> 10) & 0b11111)
    sprintf("#%02x%02x%02x", r, g, b)
  end

  def color
    'black'
  end

  def run
    do_request
    build_ui
  rescue
    on_error
  end
end

