require 'tropy'
require 'koya/koya'
require 'koya/klass'
require 'koya/quoya'

class KoyaTropy < AbstractTropy
  class Leaf < Koya::KoyaObject
    def initialize(key)
      @key = key
      @text = nil
      @title = nil
      @body = nil
    end
    attr_reader :key
    attr_accessor :text, :title, :body
    
    def to_hash
      {
        :key => @key,
        :text => @text,
        :title => @title,
        :body => @body
      }
    end
  end
  
  def initialize(db='tropy_koya.db')
    super()
    @koya = Koya::VillaStore.new(db, false)
    @root = @koya.root
    @root.transaction do
      unless @root['dict']
        @root['dict'] = Koya::Dict.new
        @root['stream'] = Koya::Stream.new
      end
      @hash = @root['dict']
      @list = @root['stream']
      do_replace(0, "Tropy\na tropy clone.") if @list.size <= 0
    end
  end

  def add(text)
    replace(0, text)
  end
  
  def replace(key, text)
    key = make_key if key == 0
    do_replace(key, text)
  end

  def gc
    @koya.gc
  end

  def any
    @list.transaction do
      @list[rand(@list.size)].to_hash
    end
  end
  
  def [](key)
    @hash.transaction do
      (@hash[key] || @hash[0]).to_hash
    end
  end

  private
  def do_replace(key, text)
    title, body = get_title_body(text)

    @root.transaction do
      leaf = @hash[key]
      unless leaf
        leaf = Leaf.new(key)
        @hash[key] = leaf
        @list.push(leaf)
      end

      leaf.text = text
      leaf.title = title
      leaf.body = body

      leaf.to_hash
    end
  end
end

