require 'tropy'

class SimpleTropy < AbstractTropy
  Event = Struct.new(:key, :text)
  Leaf = Struct.new(:key, :text, :title, :body)
  
  class Leaf
    def to_hash
      h = Hash.new
      each_pair do |k, v|
        h[k] = v
      end
      h
    end
  end
  
  def initialize(fname = 'tropy_db.log')
    super()
    @hash = Hash.new
    @list = Array.new
    @fname = fname
    load_log
    do_replace(0, "Tropy\na tropy clone.") if @list.empty?
  end

  def add(text)
    replace(0, text)
  end
  
  def replace(key, text)
    key = make_key if key == 0
    do_replace(key, text).to_hash
  end

  def any
    @list[rand(@list.size)].to_hash
  end
  
  def [](key)
    @hash.fetch(key, @hash[0]).to_hash
  end

  private
  def load_log
    File.open(@fname, 'rb') do |f|
      until f.eof?
        event = Marshal.load(f)
        do_event(event)
      end
    end
  rescue
  end

  def do_event(ev)
    key = ev.key
    text = ev.text
    title, body = get_title_body(text)
    
    leaf = @hash[key]
    unless leaf
      leaf = Leaf.new(key)
      @hash[key] = leaf
      @list.push(leaf)
    end

    leaf.text = text
    leaf.title = title
    leaf.body = body

    leaf
  end

  def do_replace(key, text)
    ev = Event.new(key, text)
    File.open(@fname, 'ab') do |f|
      f.write(Marshal.dump(ev))
    end
    do_event(ev)
  end
end
