class TropyDaemon
  def initialize(db)
    @db = db
  end

  def run(cgi)
    ui = TropyUI.new(cgi, @db)
    ui.run
  end

  def [](key)
    if key == 'db'
      return @db
    else
      return nil
    end
  end
end
 
class AbstractTropy
  def initialize
    @null_leaf = {
      :key => 0, :text => "Tropy\na tropy clone.",
      :title => 'Tropy',
      :body => 'a tropy clone.'
    }
  end

  def add(text)
    @null_leaf
  end
  
  def replace(key, text)
    @null_leaf
  end

  def any
    @null_leaf
  end
  
  def [](key)
    @null_leaf
  end

  private
  def get_title_body(text)
    if text =~ /^(.*)$/
      [$1, text.sub(/^(.*)$/, '')]
    else
      ['', text]
    end
  end
  
  def make_key
    rand(100000000)
  end
end
