# -*- indent-tabs-mode: nil -*-

require 'koya'

module KoyaStack
  class Node < Koya::KoyaObject
    def initialize(parent=nil)
      self.name = "#{self.class}-#{@_koya_.rowid}"
      self.values = Koya::KoyaDict.new
      self.forward = nil
      self.backward = nil
      self.parent = parent
    end
    koya_attr :name, :values, :forward, :backward, :parent
    
    def insert_after(node)
      transaction do
        self.forward.backward = node if self.forward

        node.backward = self
        node.forward = self.forward
        self.forward = node
      end
    end

    def insert_before(node)
      transaction do
        self.backward.forward = node if self.backward

        node.forward = self
        node.backward = self.backward
        self.backward = node
      end
    end

    def delete
      transaction do
        self.forward.backward = self.backward if self.forward
        self.backward.forward = self.forward if self.backward
      end
    end
    
    def head
      search_end do |curr|
        curr.backward
      end
    end

    def tail
      search_end do |curr|
        curr.forward
      end
    end

    private
    def search_end
      transaction do
        curr = self
        while node = yield(curr)
          curr = node
        end
        curr
      end
    end
  end

  class Field < Node
  end

  class Card < Node
    def initialize(parent)
      super()
      set_parent(parent)
      set_contents(Field.new(self))
    end
    koya_attr :contents
  end
end

if __FILE__ == $0
  k = Koya::Store.new('stack.db')
  stack = k.transaction do
    k.root['stack'] ||= KoyaStack::Node.new
  end

  stack.transaction do
    stack.insert_after(KoyaStack::Node.new)
    stack.insert_after(KoyaStack::Node.new)
    stack.insert_after(KoyaStack::Node.new)
    stack.insert_before(KoyaStack::Node.new)
    stack.insert_before(KoyaStack::Node.new)
    stack.insert_before(KoyaStack::Node.new)
  end

  stack = stack.head

  stack.transaction do
    n = stack
    while n
      p n.name
      n = n.forward
    end
  end

  puts

  stack.transaction do
    n = stack.tail
    while n
      p n.name
      n = n.backward
    end
  end

  k.root['stack'] = nil
  k.gc
end
