require 'koya'
require 'koya/quoya'

class Page < Koya::KoyaObject
  def initialize(url)
    @url = url
    @created = Time.now
  end
  attr_reader :url
end

class World < Koya::KoyaObject
  def initialize
    @dict = Koya::Dict.new
  end

  def add(page, key)
    bag = (@dict[key] ||= Koya::Set.new)
    bag.add(page)
  end

  def search(key)
    bag = @dict[key] or []
  end
end

koya = Koya::VillaStore.new('db_slow.db')
world = koya.transaction do
  koya.root['world'] ||= World.new
end

if ARGV[0] == '-a'
  ARGV.shift
  while arg = ARGV.shift
    keys = File.read(arg).split(/\W/).uniq.find_all {|s| s.size > 0}
    world.transaction do
      p arg
      page = Page.new(arg)
      keys.each do |key|
        world.add(page, key)
      end
    end
  end
elsif ARGV[0] == '-v'
  koya.gc
else
  world.search(ARGV.shift).each do |x|
    p x.url
  end
end
