require 'div'
require 'div/js'
require 'quit_db'

module QuitDiv
  class QuitSession < Div::TofuSession
    DB = QuitDB.new

    def initialize(bartender, hint=nil)
      super(bartender, hint)
      @db = DB
      @base = BaseDiv.new(self)
      @author = nil
      @latest = @db.latest
    end
    attr_reader :db
    attr_accessor :author

    def do_GET(context)
      update_div(context)

      return if do_inner_html(context)

      context.res_header('content-type', 'text/html; charset=ShiftJIS')
      context.res_body(@base.to_div(context))
    end

    def has_unopened?
      @latest != @db.latest
    end

    def updated
      @latest = @db.latest
    end
  end

  class ArriveDiv < Div::Div
    ARRIVE_RHTML = <<-EOD
<%= update_after(@interval, context) %>
<% if @session.has_unopened? %>
<%= on_update_script('document.title = "Arrived!"') %>
<h1 style='color: red'><%=h title %></h1>
<% else %>
<%= on_update_script('document.title = "quitter"') %>
<h1><%=h title%></h1>
<% end %>
    EOD
    ERB.new(ARRIVE_RHTML).def_method(self, 'to_html(context)')

    def initialize(session)
      super(session)
      @db = session.db
      @interval = 10000
    end
    attr_reader :interval

    def title
      @session.author ? @session.author.name : 'quitter'
    end
  end

  class BaseDiv < Div::Div
    def initialize(session)
      super(session)
      @db = session.db
      @page = 0
      @size = 5
      @arrive = ArriveDiv.new(session)
    end
    attr_reader :arrive

    def do_write(context, params)
      text ,= params['msg']
      return if text.to_s.empty?
      @db.add(author, text)
      @session.updated
    end

    def do_author(context, params)
      text ,= params['author']
      return if text.to_s.empty?
      @session.author = @db.author(text)
    end

    def do_head(context, params)
      @page = 0
    end

    def do_older(context, params)
      @page += 1
    end

    def author
      @session.author
    end

    def bgcolor
      author ? author.color : "#FFFFFF"
    end

    def color
      'black'
    end

    EDIT_FORM_RHTML = <<-EOD
<%= form('write', context) %>
<input type='text' name='msg' /><br /><input type="submit" value="Write" />
</form>
    EOD
    ERB.new(EDIT_FORM_RHTML).def_method(self, 'edit_form(context)')

    AUTHOR_FORM_RHTML = <<-EOD
<%= form('author', context) %>
login: <input type='text' name='author' /><input type="submit" value="yes" />
</form>
    EOD
    ERB.new(AUTHOR_FORM_RHTML).def_method(self, 'author_form(context)')

    READ_MESSAGE_RHTML = <<-EOD
<table width=90%>
<% @db.tail(@page * @size, @size).each do |leaf| %>
  <tr bgcolor='<%= leaf.author.color %>'><td>
  <p><%=h leaf.text %><p>
  <small><p style='color: gray'><%=h leaf.author.name %>/<%= leaf.time.strftime("%H:%M:%S") %></p></small>
  </td></tr>
<% end %>
<% @session.updated %>
</table>
    EOD
    ERB.new(READ_MESSAGE_RHTML).def_method(self, 'read_message(context)')

    BASE_RHTML = <<-EOD
<html lang="ja">
<head>
<meta http-equiv="content-type" content="text/html; charset=Shift_JIS">
<meta http-equiv="content-style-type" content="text/css">
<style type="text/css"><!--
body{font-family:Verdana,sans-serif;margin:2% 20% 10% 20%;color:<%= color%>;background-color:<%= bgcolor%>;}
input{font-family:Verdana,sans-serif;}
#navi{text-align:right;}
p{line-height:150%;}
a{color:gray;background-color:<%= bgcolor %>;text-decoration:none;}
a:hover{text-decoration:underline;color:white;background-color:gray;}
--></style>
<script language="javascript">
<%= update_js %>
</script>
<title>Quitter</title>
</head>
<body onload='setTimeout(<%= @arrive.update_me(context).dump%>, <%= @arrive.interval %>)'>
<%= @arrive.to_div(context) %>
<% if author %>
 <%= edit_form(context) %>
<% else %>
 <%= author_form(context) %>
<% end %>
<%= read_message(context) %>
<p id="navi">
  <%= a('head', {}, context) %>Newest</a>
  <%= a('older', {}, context) %>Older</a>
</p>
</div></body></html>
    EOD

    ERB.new(BASE_RHTML).def_method(self, 'to_html(context)')

    ON_ERROR_RHTML = <<-'EOD'
Content-Type: text/html;

<html><head><title>Error</title></head><body><h1>Error</h1><pre>
<%=h "#{$!} (#{$!.class})" %>
<%=h $@.join("\n") %>
</pre>
    EOD

    ERB.new(ON_ERROR_RHTML).def_method(self, 'on_error()')
  end
end
