require 'koya/koya'
require 'koya/klass'
require 'koya/quoya'
require 'digest/md5'

class QuitDB
  class QuitList < Koya::Dict
    def add(leaf)
      self[leaf.key] = leaf
    end

    def keys
      super.sort
    end
  end

  class QuitAuthor < Koya::KoyaObject
    def initialize(name)
      @name = name
      @color = bgcolor
    end
    attr_reader :name, :color

    def bgcolor
      k ,= Digest::MD5.digest(@name).unpack('L')
      r = 255 - (k & 0b11111)
      g = 255 - ((k >> 5) & 0b11111)
      b = 255 - ((k >> 10) & 0b11111)
      sprintf("#%02x%02x%02x", r, g, b)
    end
  end

  class QuitLeaf < Koya::KoyaObject
    ETERNAL = (2 ** 31 - 1).to_f

    def initialize(author, text)
      @time = Time.now
      @text = text
      @author = author
    end
    attr_accessor :time, :text, :author
    
    def key
      "%20.8f" % (ETERNAL - @time.to_f)
    end

    def to_a
      [time, author.name, text]
    end
  end
  
  def initialize(db='db_quit.koya')
    super()
    @koya = Koya::VillaStore.new(db, false)
    @root = @koya.root
    @root.transaction do
      unless @root['list']
        @root['list'] = QuitList.new
        @root['author'] = Koya::Dict.new
      end
      @list = @root['list']
      @author = @root['author']
    end
    @latest = nil
  end
  
  def latest
    @list.transaction do
      key = @list.keys[0]
      return nil unless key
      @list[key]
    end
  end

  def add(author, text)
    @list.transaction do
      @list.add(QuitLeaf.new(author, text))
    end
  end
  
  def tail(start=0, size=20)
    (@list.keys[start, size] || []).collect do |key|
      @list[key]
    end
  end

  def author(name)
    @author.transaction do
      @author[name] = QuitAuthor.new(name) unless @author[name]
      @author[name]
    end
  end
end
