require 'koya'

class LinkedQueue < Koya::KoyaObject
  class Cell < Koya::KoyaObject
    def initialize(value)
      self.value = value
    end
    koya_attr('value')
    koya_attr('next')
  end

  def initialize
    sentinel = Cell.new(nil)
    self.head = sentinel
    self.tail = sentinel
  end
  koya_attr('tail')
  koya_attr('head')

  def enq(obj)
    transaction do
      cell = Cell.new(obj)
      self.tail.next = cell
      self.tail = cell
    end
  end

  def deq
    loop do
      transaction do
        head = self.head.next
        
        if head
          self.head = head
          return head.value
        end
      end
      
      if block_given? 
        return nil unless yield
      end
      sleep(@_koya_.store.polling_interval)
    end
  end
end

class StreamQueue < Koya::KoyaObject
  def initialize
    self.stream = Koya::KoyaStream.new
  end
  koya_attr(:stream)

  def enq(obj)
    self.stream.push(obj)
  end

  def deq
    loop do
      transaction do
        stream = self.stream
        if stream.size > 0
          return stream.shift
        end
      end
      
      if block_given? 
        return nil unless yield
      end
      sleep(@_koya_.store.polling_interval)
    end
  end
end

if __FILE__ == $0
  koya = Koya::Store.new('queue.db')
  root = koya.root

  queue_class = StreamQueue

  root.transaction do
    unless root['queue']
      root['queue'] = queue_class.new
    end
  end

  queue = root['queue']

  if ARGV[0] == 'deq'
    while it = queue.deq
      p it
    end
  elsif ARGV[0] == 'revert'
    rev = Time.now - (ARGV[1] || 60).to_i
    koya.revert_to(rev)
  else
    [1, 2, 3, 4, 5, nil].each do |n|
      p n
      sleep(rand)
      queue.enq(n)
    end
  end

  queue.stream._koya_.revisions('size').each do |x|
    p x
  end
end

