require 'koya'

class History < Koya::KoyaStream
  private
  def store(index, value)
    @_koya_[index] = value
    @_koya_["#{index}.time"] = Time.now
  end

  def fetch(index, remove=false)
    [@_koya_["#{index}.time"], @_koya_[index]]
  ensure
    @_koya_.delete(index) if remove
    @_koya_.delete("#{index}.time") if remove
  end
end

if __FILE__ == $0
  db = Koya::Store.new('log.db')
  db.transaction do
    unless db.root['log'] 
      db.root['log'] = History.new
    end
  end
  
  v = db.root['log']

  v.push(ARGV)

  v[-5..-1].each do |v|
    p v
  end
end
