require 'div'

module KorhoDiv
  class TDiaryStyleDiv < Div::Div
    set_erb('korho_style.erb')

    THEME = %w(
3minutes            easy                  lovely_pink       rectangle
3pink               emboss                lr                redgrid
90                  fine                  madrascheck       repro
                    flower                magic             right
                    fluxbox               manuscript-brown  rim-daidaiiro
alfa                fluxbox2              manuscript-green  rim-fujiiro
another_blue        fluxbox3              marguerite        rim-mizuiro
aoikuruma           fri                   maroon            rim-sakurairo
aqua                futaba                matcha            rim-tanpopoiro
arrow               garden                memo              rim-wakabairo
artnouveau-blue     gardenia              memo2             russet
artnouveau-green    gear                  memo3             s-blue
artnouveau-red      germany               metal             s-pink
asterisk-blue       gingham-blue          midnight          sagegreen
asterisk-lightgray  gingham-gray          mini-g            sakana
asterisk-maroon     gingham-green         mini-p            sakura
asterisk-orange     gingham-purple        mintblue          savanna
asterisk-pink       gingham-yellow        mirage            scarlet
at                  giza                  mixi              seam-line
autumn              glass                 mixi-blue         sepia
babypink            gold                  mixi-green        shirakaba
be_r5               gray                  mixi-pink         sidelight
bill                gray-note             mizu              silver
bistro_menu         gray2                 momiji            silver2
black-blue          green-border          momonga           simple
black-green         green-tea             mono              simpleblack
black-lingerie      green_leaves          monochrome        sky
black-red           greentea3             monotone          sleepy_kitten
black_mamba         halloween             moo               smoking_black
blackboard          happa                 mt_fuji           smoking_gray
blackbox            haru                  nachtmusik        smoking_white
blue-border         hatena                nahanaha          snake
blue-dash           hatena-black          nande-ya-nen      snow_man
blue-feather        hatena-brown          narrow            snowy
bluegrad            hatena-darkgray       natrium           soda
bluely              hatena-green          natural_gray      sodapop
book                hatena-lightblue      navy              soft-gold
book2-feminine      hatena-lightgray      nebula            spring
book3-sky           hatena-lime           necktie           starlight
bright-green        hatena-orange         nenga             stripe
britannian          hatena-pink           nippon            subdued
brown               hatena-purple         noel              summer_wave
bubble              hatena-red            note              sunset
candy               hatena-sepia          nut-brown         tag
cards               hatena-tea            ocha              tdiarynet
cat                 hatena-white          old-pavement      te
check               hatena_cinnamon       orange            teacup
cherry              hatena_japanese       orange-blue       themebench.rhtml
cherry_blossom      hatena_leaf           orange-border     thin
cherry_blossom_r    hatena_rainyseason    orange_flower     tile
chiffon_leafgreen   hatena_savanna-blue   orangegrad        tinybox
chiffon_pink        hatena_savanna-green  orkut             tinybox_green
chiffon_skyblue     hatena_savanna-red    pain              tour-de-hokkaido
christmas           hatena_savanna-white  pale              town
citrus              hatena_water          paper             treetop
city                hazakura              parabola          triple_gray
clover              hellali               pastelpink        tuki
colorlabel          himawari              pearl             utsusemi
cool_ice            husen                 petith            vi
cosmos              hydrangea             petith-b          w2k_button
cross               iris                  pettan            wall1
curtain             jungler               pict              wall2
darkness-pop        kaeru                 pink-border       wall3
darkwhite           kaizou                pinkgrad          wall4
date                kaki                  piyo-family       wall5_tatami
deepblue            kanban                plum              white
delta               kanshin               pokke-blue        white-lingerie
desert              kasumi                pokke-orange      white_flower
diamond_dust        kitchen-classic       pool_side         whiteout
dice                kitchen-french        pudding           widthfix
digital_gadgets     kitchen-natural       puppy             will
dog                 kotatsu               purple_sun        windowz
dot                 kurenai               query000          wine
dot-lime            lcars                 query011          winter
dot-orange          lcd                   query101          wood
dot-pink            leafgreen             query110          xmastree
dot-sky             light-blue            query111or        xxx
dotted_line-blue    lightning             quiet_black       ymck
dotted_line-green   lime                  quirky            yukon
dotted_line-red     line                  quirky2           zef
double              loose-leaf            rain
earth-brown         lovely                rainy-season
).sort

    def initialize(session, korho)
      super(session)
      @korho = korho
    end

    def theme_each
      url = 'http://www.druby.org/theme/'
      THEME.each do |name|
        yield(name, url + "#{name}/#{name}.css")
      end
    end

    def to_args(param)
      css ,= param['css']
      args = {}
      args[:css] = css if css.to_s.size > 0
      args
    end

    def set_css(found)
      @korho.css = found if found
    end

    def do_css(context, param)
      args = to_args(param)
      return unless args[:css]
      set_css(args[:css])
    rescue
      p $!
    end
  end
end
