require 'koya'
require 'koya/log'

class KoyaGCAgent
  def initialize(name)
    @store = Koya::Store.new(name)
    @gc_interval = 110
    @baby_gc_interval = 60
    @logging = true
    @store.transaction do
      @log = @store.root['gc_log']
      unless @log
        @log = Koya::LogStream.new
        @store.root['gc_log'] = @log
        @log.limit = 10
      end
    end
  end
  attr_accessor :logging, :gc_interval, :baby_gc_interval

  def count
    @store.transaction do |h|
      h.get_first_value('select count(*) from memory').to_i
    end
  end

  def gc
    main_loop do
      sleep(@gc_interval)
      log("begin GC (#{count})")
      @store.gc
      log("done (#{count})")
    end
  end

  def baby_gc
    main_loop do
      sleep(@baby_gc_interval)
      log("begin BabyGC (#{count})")
      @store.baby_gc
      log("done (#{count})")
    end
  end

  private
  def log(str)
    return unless @logging
    @log << str
  end

  def main_loop
    Thread.new do
      loop do
        begin
          yield
        rescue
          log($!.inspect)
        end
      end
    end
  end
end

if __FILE__ == $0
  ag = KoyaGCAgent.new(ARGV.shift)
  ag.gc
  ag.baby_gc.join
end
