#!/usr/local/bin/ruby -Ke

require 'etc'

# from WEBrick::Utils
def su(user, group=nil)
  if defined?(Etc)
    pw = Etc.getpwnam(user)
    gr = group ? Etc.getgrnam(group) : pw
    Process::gid = gr.gid
    Process::egid = gr.gid
    Process::uid = pw.uid
    Process::euid = pw.uid
  end 
end   

unless $DEBUG
  # Run as a daemon...
  exit!( 0 ) if fork
  Process.setsid
  exit!( 0 ) if fork
  
  su('nobody')
end

require 'yourapp'
require 'drb/drb'
require 'tofu/proxy'

tofu = Tofu::Bartender.new(YourTofuSession)
DRb.start_service('druby://localhost:7643', tofu)
DRb.thread.join

unless $DEBUG
  STDIN.reopen('/dev/null')
  STDOUT.reopen('/dev/null', 'w')
  STDERR.reopen('/dev/null', 'w')
  DRb.thread.join
else
  gets
  exit
end
