require 'div/div'
require 'div/login'
require 'delegate'
require 'singleton'
require 'monitor'

class MyLoginDiv < Div::LoginDiv
  set_erb('login.erb')
  
  def initialize(session, model, hint)
    super(session, model, hint)
    # @login.guest_login unless @login.login?
  end
  
  def do_begin(context, params)
    @login.logout
  end
end

class MyLogin < Div::Login

  Guest = { :id => 'guest', :name => 'guest' }    

  class User < DelegateClass(String)
    def initialize(user, username)
      @user = user
      @username = username
      super(@user)
    end
    attr_reader :username
  end

  def initialize(db)
    super()
    @db = db
  end

  def get_user(user, pass)
    @db.get_user(user, pass)
  end
  
  def name
    @user ? @user[:name] : nil
  end
  
  def guest_user
    Guest
  end
end
