#!/usr/local/bin/ruby

# rwiki.rb
#
# Copyright (c) 2000-2003 Masatoshi SEKI
#
# rwiki.rb is copyrighted free software by Masatoshi SEKI.
# You can redistribute it and/or modify it under the same term as Ruby.

$KCODE = 'EUC'

module RWiki
  # RWiki Server setup
  ## Page 
  ADDRESS = 'Masatoshi SEKI'
  MAILTO = 'mailto:m_seki@mva.biglobe.ne.jp'
  CSS = 'http://divip.sourceforge.jp/rubyStyle.css'
  LANG = nil
  CHARSET = nil
  
  ## Service
  DB_DIR = 'rd'
  TOP_NAME = 'top'
  TITLE = 'I like Ruby.'
  DRB_URI = 'druby://:8470'
end

require 'rwiki/rwiki'
require 'rwiki/rw-info'
require 'rwiki/rw-map'
require 'rwiki/rw-orphan'
require 'rwiki/rw-like'
require 'rwiki/rw-concat'
require 'section'

require 'amazon'

require 'rinda/ring'

unless $DEBUG
  # Run as a daemon...
  exit!( 0 ) if fork
  Process.setsid
  exit!( 0 ) if fork
end

book = RWiki::Book.new
front = book.front

DRb.start_service(RWiki::DRB_URI, front)

ring = Rinda::RingProvider.new(:RWiki,
			       DRbObject.new(nil, DRb.uri),
			       'I like Ruby.')
ring.provide

if $DEBUG
  while gets
    RWiki.reload_rhtml
  end
  exit
else
  STDIN.reopen('/dev/null')
  STDOUT.reopen('/dev/null', 'w')
  STDERR.reopen('/dev/null', 'w')
  DRb.thread.join
end

