require 'div/tofusession'
require 'tofu/tofulet'
require 'rwiki/service'
require 'hatena_auth_key'
require 'hatena/api/auth'

class RWikiTofuSession < Div::TofuSession
  include HatenaAuthKey

  @@author = ['m_seki']

  def self.rwiki=(ro)
    @@rwiki = ro
  end

  def self.author=(ary)
    @@author = ary
  end

  def initialize(bartender, hint=nil)
    super(bartender)
    @login = nil
    @hatena_auth = hatena_auth
  end

  def do_GET(context)
    hatena_cert(context)

    if @@author.include?(@login)
      service = RWiki::Service.new(@@rwiki, Logger::Severity::INFO)
    else
      service = RWiki::RestrictService.new(@@rwiki, Logger::Severity::INFO)
    end
    service.serve(context.webrick_req, context.webrick_res)
  end

  def hatena_cert(context)
    cert ,= context.req_params['cert']
    if cert
      begin
        user = @hatena_auth.login(cert)
        @login = user['name']
      rescue
        p $!
      end
    else
      redirect_to_login(context) unless @login
    end
  end

  def redirect_to_login(context)
    context.res_header('status', '302')
    context.res_header('location', @hatena_auth.uri_to_login)
    context.res_body('')
    context.done
  end

  def hatena_auth
    Hatena::API::Auth.new(:api_key => API_KEY, :secret => SECRET)
  end
end

module RWiki
  class RestrictService < Service
    def parse_request(params, do_validate=true)
      req = super(params, do_validate)
      unless (req.cmd || 'view') == 'view'
        req = RWiki::Request.new(nil, nil, nil, nil, false)
      end
      req
    end
  end
end


if __FILE__ == $0
  $KCODE = 'EUC'

  ENV["LANG"] = "en"

  module RWiki
    ADDRESS = 'Masatoshi SEKI'
    MAILTO = 'mailto:m_seki@mva.biglobe.ne.jp'
    CSS = 'http://divip.sourceforge.jp/rubyStyle.css'
    LANG = nil
    CHARSET = nil

    DB_DIR = 'rd'
    CACHE_DIR = 'cache'
    TOP_NAME = 'top'
    TITLE = 'RWiki'

    AVAILABLE_LOCALES = ["ja", "ja_JP", "en"]
  end

  require 'rwiki/rwiki'
  require 'rwiki/front'
  require 'rwiki/info'
  require 'rwiki/map'
  require 'rwiki/orphan'
  require 'rwiki/like'

  unless $DEBUG
    exit!( 0 ) if fork
    Process.setsid
    exit!( 0 ) if fork
  end

  book = RWiki::Book.new
  front = book.front
  tofu = Tofu::Bartender.new(RWikiTofuSession)
  RWikiTofuSession.rwiki = front
  RWikiTofuSession.author = ['m_seki']
  tofulet = WEBrick::CGITofulet.new(tofu)

  DRb.start_service('druby://localhost:8471', 
                    {'tofu'=>tofulet, 'rwiki'=>front})

  if $DEBUG
    while gets
      RWiki.reload_rhtml
    end
    book.close
  else
    STDIN.reopen('/dev/null')
    STDOUT.reopen('/dev/null', 'w')
    STDERR.reopen('/dev/null', 'w')
    trap("TERM") { book.close; exit }
    DRb.thread.join
  end
end
