require 'div'
require 'reminder-div'
require 'todo-div'
require 'paper-div'
require 'rwiki-div'
require 'hako-div'
require 'singleton'
require 'raa-div'
require 'frame-div'
require 'enquete-div'

require 'div/tofusession'

class LoginDiv < Div::Div
  set_erb('login.erb')

  def initialize(session)
    super(session)
    @status = nil
  end

  def show
    @status = :show
  end

  def do_show(req, params)
    show
  end

  def do_logout(req, params)
    logout(@session)
  end
  
  def do_login(req, params)
    username, = params['username']
    password, = params['password']
    login(@session, username, password)
  end

  def login(session, username, password)
    begin
      session.login(username, password)
      @status = :succ
    rescue
      @status = :fail
    end
  end

  def logout(session)
    session.login('guest', nil)
    @status = nil
  end
end

class Banner < Div::Div
  set_erb('banner.erb')
end

class Base < Div::Div
  set_erb('base.erb')

  def initialize(session)
    super
    @banner = Banner.new(session)
    @login = LoginDiv.new(session)
    # @login.show
    @reminder = ReminderDiv.new(session, session.app.reminder)
    @todo = TodoDiv.new(session, session.app.todo)
    @rwiki = RWikiDiv.instance
    @hako = HakoDiv.new(session)
    @raa = RAADiv.instance
    @frame = TableFrameKagi.new(@rwiki)
    @enquete = EnqueteDiv.new(session, session.app.enquete_db)
  end
end

class TofuSampleSession < Div::TofuSession
  def initialize(bartender, hint=nil)
    super(bartender, hint)

    @app = TofuSampleApp.instance
    @prefix = bartender.prefix
    @username = nil
    @base = Base.new(self)
    @status = :init
    @expires = nil
    @hint = 'guest' if hint.nil? || hint==''
  end
  attr_reader :username, :status, :expires, :app
  attr_accessor :key

  def guestname
    @hint
  end

  def login(name, password)
    @app.login.login(name, password)
    @username = name
    @hint = @username
  end

  def do_GET(context)
    update_div(context)

    if context.req_params.size == 0
      context.res_header('content-type', 'text/html; charset=euc-jp')
      context.res_body(@base.to_html(context))
    else
      context.res_header('status', '302')
      context.res_header('location', 
			 context.req_script_name + context.req_path_info)
      context.res_body('')
    end
    @status = nil
    @expires = Time.now + 900
  end
end

class TofuSampleApp
  include Singleton

  @@data_dir = nil
  def self.data_dir=(dir)
    @@data_dir = dir
  end

  def initialize
    require 'login'
    require 'reminder'
    require 'todo'

    if @@data_dir
      Login.filename = File::join(@@data_dir, 'login.db')
      Todo.filename = File::join(@@data_dir, 'todo.db')
      Reminder.filename = File::join(@@data_dir, 'reminder.db')
      EnqueteDB.filename = File::join(@@data_dir, 'enquete.db')
    end

    @login = Login.instance
    @reminder = Reminder.instance
    @todo = Todo.instance
    @enquete_db = EnqueteDB.instance
  end
  attr_reader :login, :reminder, :todo, :enquete_db
end

if __FILE__ == $0
  require 'drb/drb'
  require 'tofu/proxy'
  
  tofu = Tofu::Bartender.new(TofuSampleSession)
  DRb.start_service('druby://localhost:7642', tofu)
  DRb.thread.join
end
