require 'div'
require 'parsedate'

class TodoDiv < Div::Div
  set_erb('todo.erb')

  def initialize(session, todo)
    super(session)
    @todo = todo
    @mode = :browse
  end

  def remove(key)
    @todo.remove(session.username, key)
  end

  def add(text, time, priority)
    @todo.add(text, session.username, time, priority)
  end

  def to_args(params)
    key, = params['key']
    text, = params['text']
    time, = params['time']
    priority, = params['priority']
    time = Time.local(*(ParseDate.parsedate(time)[0,6])) if time
    return key, text, time, priority
  end

  def do_remove(context, params)
    key, = to_args(params)
    remove(key)
  end

  def do_edit(context, params)
    @mode = :edit
  end
  
  def do_browse(context, params)
    @mode = :browse
  end

  def do_set(context, params)
    key, text, time, priority = to_args(params)
    remove(key)
    add(text, time, priority)
    @mode = :browse
  end

  def do_add(context, params)
    key, text, time, priority = to_args(params)
    add(text, time, priority)
    @mode = :browse
  end
end

