require 'div/div'

class TableFrame < Div::Div
  class Img
    def initialize(url, w, h)
      @url = url
      @w = w
      @h = h
      @scale = 1.0
    end
    attr_accessor :scale

    def w
      (@scale * @w).to_i
    end

    def h 
      (@scale * @h).to_i
    end

    def to_s
      # "<img src='#{@url}' width='#{w}' height='#{h}' />"
      "<img src='#{@url}' />"
    end
  end

  def initialize(div)
    @sub_div = div
  end
  
  def to_html(context)
    if @sub_div
      @sub_div.to_html(context)
    else
      ""
    end
  end

  private
  def find_file(fname)
    return fname if File::readable?(fname)
    found = fname # default
    $:.each do |dir|
      path = File::join(dir, fname)
      if File::readable?(path)
	found = path
	break
      end
    end
    found
  end
end

class TableFrameKagi < TableFrame
  def initialize(div, scale=1.00)
    super(div)

    prefix = "http://www2a.biglobe.ne.jp/~seki/icon/"
    @top = Img.new(prefix + 'top1.gif', 90, 40)
    @left = Img.new(prefix + 'left1.gif', 40, 60)
    @right = Img.new(prefix + 'right1.gif', 40, 60)
    @bottom = Img.new(prefix + 'bottom1.gif', 90, 40)
    
    [@top, @left, @right, @bottom].each do |img|
      img.scale = 1.0
    end
  end

  def to_html(context)
    open(context) + super(context) + close(context)
  end

  def open(context)
    <<EOS
<table border="0" width="100%" cellpadding="0" cellspacing="0">
<tr>
<td valign="bottom" align="left" colspan="2">#{@top}</td>
<td>&nbsp;</td>
</tr>
<tr>
<td valign="top">#{@left}</td>
<td>
EOS
  end

  def close(context)
    <<EOS
</td>
<td align="right" valign="bottom">#{@right}</td>
</tr>
<tr>
<td>&nbsp;</td>
<td valign="top" align="right" colspan="2">#{@bottom}</td>
</tr>
</table>
EOS
  end
end
