module ABLoad
  class XmlFormatter
    def initialize(output=[])
      @cur = 1
      @map = {}
      @child = []
      @output = output
    end
    attr_reader :output

    def string(s)
      s.to_s.gsub(/&/, "&amp;").gsub(/\"/, "&quot;").gsub(/>/, "&gt;").gsub(/</, "&lt;")
    end

    def feed(obj)
      return if @map[obj.id]
      @map[obj.id] = @cur
      @cur += 1
      @child.push(obj)
    end

    def finish
      @child.each do |r|
	begin_obj(r)
	body_value(r)
	ivars(r)
	end_obj(r)
      end
    end

    def dump(stream)
      stream.each do |obj|
	feed(obj)
      end
      finish
    end

    def put(s)
      @output.push s
    end

    def begin_obj(r)
      put %Q!<obj xsi:type="myns:#{r.klass}" id="id#{@map[r.id]}">! 
    end

    def ivars(r)
      r.ivars.each do |k, v|
#      r.ivars.keys.sort.each do |k, v|
	name = k.to_s.sub(/^@/, '')
	put %Q!  <#{name} href="#id#{@map[v.id]}" />!
      end
    end

    def body_value(r)
      if r.klass >= Array
	r.body.each do |e|
	  put %Q!  <item href="#id#{@map[e.id]}" />!
	end
      elsif r.klass >= Bignum
	put r.body[0]
      elsif r.klass >= Fixnum
	put r.body[0]
      elsif r.klass >= Hash
	it = r.attr[:default]
	put %Q!  <default href="#id#{@map[it.id]}" />!
	ary = r.body.dup
	while (ary.size > 0) do
	  put '  <pair>'
	  put %Q!    <key href="#id#{@map[ary.shift.id]}" />!
	  put %Q!    <value href="#id#{@map[ary.shift.id]}" />!
	  put '  </pair>'
	end
      elsif r.klass >= String
	put string(r.body[0])
      elsif r.klass >= Struct
	ary = r.body.dup
	while (ary.size > 0) do
	  put '  <pair>'
	  put %Q!    <key href="#id#{@map[ary.shift.id]}" />!
	  put %Q!    <value href="#id#{@map[ary.shift.id]}" />!
	  put '  </pair>'
	end
      elsif r.klass >= Symbol
	put string(r.body[0])
      elsif r.klass >= Time
          put %Q!  <sec>#{r.attr[:sec]}</sec>!
          put %Q!  <usec>#{r.attr[:usec]}</usec>!
      end
    end
    
    def end_obj(r)
      put '</obj>'
    end
  end
end
