require 'thread'

class Class
  # import from AMarshal
  def allocate
    return Marshal.load(sprintf("\004\006o:%c%s\000", name.length + 5, name))
  end
end

module ABLoad
  class Destructive
    # import from AMarshal
    def self.set_ivars(obj, hash)
      self.new.set_ivars(obj, hash)
    end

    def self._load(str)
      Thread.current[self.name][str]
    end

    def initialize
      @hash = {}
      @num = 0
    end
    
    def [](key)
      @hash[key]
    end

    def regist(obj)
      str = (@num += 1).to_s
      @hash[str] = obj
      sprintf("u:\030ABLoad::Destructive%c%s", str.length + 5, str)
    end

    def unique(name)
      str = name.to_s
      sprintf(":%c%s", str.length + 5, str)
    end

    def set_ivars(obj, hash)
      Thread.current[self.class.name] = self
      o_str = self.regist(obj)
      hash.each do |k, v|
	k_str = self.unique(k)
	v_str = self.regist(v)
	Marshal.load sprintf("\004\006I%s\006%s%s", o_str, k_str, v_str)
      end
      Thread.current[self.class.name] = nil
      obj
    end
  end

  class Desc
    def initialize
      @klass = nil
      @body = []
      @attr = {}
      @ivars = {}
    end
    attr_accessor :klass, :ivars, :body, :attr

    Primitive = [
      String, Bignum, Fixnum, Float, TrueClass, FalseClass, NilClass, Desc
    ]
      
    def push_body(it)
      raise("Can't store " + it.class.name) unless Primitive.include?(it.class)
      @body.push(it)
    end

    def put_attr(k, v)
      raise("Can't store " + v.class.name) unless Primitive.include?(v.class)
      @attr[k] = v
    end
  end

  class Traverser
    def initialize
      @map = {}
      @limit = nil
      @stream = []
      @cur = nil
    end
    attr_accessor :map, :limit, :stream

    def dump(obj)
      put(obj)
    end

    # internal
    def make_desc(obj)
      desc = @map[obj.__id__]
      if desc
	# @stream.push desc
	return desc
      end

      desc = Desc.new
      @map[obj.__id__] = desc
      @stream.push desc
      begin
	stack = @cur
	@cur = desc

	desc.klass = obj.class

	obj.__dump(self)
      ensure
	@cur = stack
      end
      
      return desc
    end

    def put_class(klass)
      @cur.klass = klass
    end

    # for builtin class
    def put_body(v)
      @cur.push_body(v)
    end

    def put_attr(k, v)
      @cur.put_attr(k, v)
    end
    #

    def put_ivar(n, v)
      n = n.intern if n.kind_of? String
      @cur.ivars[n] = self.put(v)
    end

    def put_all_ivars(obj)
      obj.instance_variables.each do |var|
	value = obj.instance_eval var
	put_ivar(var, value)
      end
    end

    def put(obj)
      raise(ArgError, 'exeed depth limit') if @limit == 0
      make_desc(obj)
    end
  end
  
  class Loader
    def initialize
      @map = {}
      @stream = nil
      @cur = nil
    end
    
    def load(desc)
      return @map[desc.__id__] if @map.include?(desc.__id__)
      obj = load1(desc)
      allocated(desc, obj) unless @map.include?(desc.__id__)
      return @map[desc.__id__]
    end

    def allocated(desc, obj)
      @map[desc.__id__] = obj
      set_all_ivars(desc)
      obj
    end
    
    def load1(desc)
      desc.klass.__load(self, desc)
    end

    def set_all_ivars0(desc)
      obj = @map[desc.__id__]

      ivars = {}
      desc.ivars.each do |k, v|
	ivars[k] = load(v)
      end

      

      ABLoad::Destructive.set_ivars(obj, ivars)
    end

    def set_all_ivars(desc)
      obj = @map[desc.__id__]
      desc.ivars.each do |k, v|
	v = load(v)
	obj.instance_eval("#{k.to_s} = v")
      end
    end
  end

  def self.traverse(obj)
    traverse = Traverser.new
    traverse.dump(obj)
    traverse.stream
  end

  def self.load(desc)
    loader = Loader.new
    loader.load(desc)
  end
end

[IO, Binding, Continuation, Data, Dir, File::Stat, MatchData, Method, Proc, Thread, ThreadGroup].each {|c|
  c.class_eval {
    def __dump(dumper);
      raise TypeError.new("can't dump #{self.class}")
    end
  }
}

class Object
  def __dump(dumper)
    dumper.put_all_ivars(self)
  end
  
  def self.__loader(loader, desc)
    loader.allocated(desc, self.allocate)
  end
end

class Module
  def __dump(dumper)
    dumper.put_body(name)
  end
  
  def self.__load(loader, desc)
    name = desc.body[0]
    ary = name.split('::')
    mod = Kernel
    ary.each do |nm|
      mod = mod.const_get(nm)
    end
    mod
  end
end

class Class
  def __load(loader, desc)
    loader.allocated(desc, self.allocate)
  end
end

class Array
  def __dump(dumper)
    self.each do |v|
      dumper.put_body(dumper.put(v))
    end
    dumper.put_all_ivars(self)
  end
  
  def self.allocate
    Array.new
  end

  def self.__load(loader, desc)
    obj = loader.allocated(desc, self.allocate)
    desc.body.each_with_index do |v, idx|
      obj[idx] = loader.load(v)
    end
    obj
  end
end

class Exception
  def __dump(dumper)
    dumper.put_all_ivars(self)
    dumper.put_attr(:message, dumper.put(self.message))
    dumper.put_attr(:backtrace, dumper.put(self.backtrace))
  end
  
  def self.__load(loader, desc)
    message = loader.load(desc.attr[:message])
    obj = loader.allocated(desc, self.new(message)) #FIXME
    bt = loader.load(desc.attr[:backtrace])
    if Array === bt
      obj.set_backtrace(bt.collect { |x| x.to_s })
    end
    obj
  end
end

class NilClass
  def self.__load(loader, desc)
    nil
  end
end

class TrueClass
  def self.__load(loader, desc)
    true
  end
end

class FalseClass
  def self.__load(loader, desc)
    false
  end
end

class Fixnum
  def __dump(dumper)
    dumper.put_body(to_i)
  end
  
  def self.__load(loader, desc)
    desc.body[0].to_i
  end
end

class Symbol
  def __dump(dumper)
    dumper.put_body(self.id2name)
  end
  
  def self.__load(loader, desc)
    loader.allocated(desc, desc.body[0].intern)
  end
end

class Float
  def __dump(dumper)
    dumper.put_body(to_f)
  end
  
  def self.__load(loader, desc)
    # desc.body[0].dup
    desc.body[0] + 0.0 # FIXME
  end
end

class Bignum
  def __dump(dumper)
    dumper.put_body(to_i)
  end
  
  def self.__load(loader, desc)
    # desc.body[0].dup
    desc.body[0] + 0 # FIXME
  end
end

class String
  def __dump(dumper)
    dumper.put_body(to_s)
  end
  
  def self.__load(loader, desc)
    loader.allocated(desc, desc.body[0].dup)
  end
end

class Regexp
  def __dump(dumper)
    dumper.put_attr(:source, source)
    dumper.put_attr(:options, options)
  end

  def options
    v = 0
    if  /\/([mix]+)$/ =~ inspect #/
      opts = $1
      v |= Regexp::MULTILINE if opts.include? 'm'
      v |= Regexp::IGNORECASE if opts.include? 'i'
      v |= Regexp::EXTENDED if opts.include? 'x'
    end
    v
  end
  
  def self.__load(loader, desc)
    self.new(desc.attr[:source], desc.attr[:options]) #FIXME
  end
end

class Hash
  def __dump(dumper)
    dumper.put_attr(:default, dumper.put(self.default))
    self.each do |k, v|
      dumper.put_body(dumper.put(k))
      dumper.put_body(dumper.put(v))
    end
  end
  
  def self.__load(loader, desc)
    obj = loader.allocated(desc, self.new) # FIXME
    if desc.attr[:default]
      obj.default = loader.load(desc.attr[:default])
    end
    n = desc.body.size / 2
    n.times do |i|
      k = loader.load(desc.body[i * 2])
      v = loader.load(desc.body[i * 2 + 1])
      obj[k] = v
    end
    obj
  end
end

class Struct
  def __dump(dumper)
    self.members.each do |m|
      dumper.put_body(m)
      dumper.put_body(dumper.put(self[m]))
    end
  end
  
  def self.__load(loader, desc)
    obj = loader.allocated(desc, self.new)
    n = desc.body.size / 2
    n.times do |i|
      k = desc.body[i * 2]
      v = loader.load(desc.body[i * 2 + 1])
      obj[k.intern] = v
    end
    obj
  end
end

class Range
  def __dump(dumper)
    dumper.put_attr(:end, dumper.put(self.end))
    dumper.put_attr(:begin, dumper.put(self.begin))
    dumper.put_attr(:excl, dumper.put(self.exclude_end?))
  end

  def self.__load(loader, desc)
    obj = loader.allocated(desc, self.allocate)
    ivars = {}
    ivars[:begin] = loader.load(desc.attr[:begin])
    ivars[:end] = loader.load(desc.attr[:end])
    ivars[:excl] = loader.load(desc.attr[:excl])
    obj.instance_eval {initialize(ivars[:begin], ivars[:end], ivars[:excl])}
    obj
  end
end

class Time
  def __dump(dumper)
    dumper.put_attr(:sec, to_i)
    dumper.put_attr(:usec, usec)
  end
  
  def self.__load(loader, desc)
    self.at(desc.attr[:sec], desc.attr[:usec])
=begin
    obj = loader.allocated(desc, self.allocate)
    ivars = {}
    ivars[:sec] = loader.load(desc.attr[:sec])
    ivars[:usec] = loader.load(desc.attr[:usec])
    ABLoad::Destructive.set_ivars(obj, ivars)
    obj
=end
  end
end
