module ABLoad
  class RDFormat
    def self.dump(obj, port="")
      self.write(ABLoad.traverse(obj), port)
      port
    end

    def self.load(port)
      ABLoad.load(self.read(port))
    end

    def self.write(stream, output=[])
      w = Writer.new(output)
      w.write(stream)
      w.output
    end

    def self.read(src)
      r = Reader.new
      r.read(src)
    end

    class Writer
      def initialize(output=[])
	@output = output
	@name = 0
	@map = {}
      end
      attr_reader :output
      
      def write(desc_stream)
	desc_stream.each do |desc|
	  if Lit.include?(desc.klass)
	    @map[desc.__id__] = Lit[desc.klass]
	  else
	    @name += 1
	    @map[desc.__id__] = @name
	  end
	end

	if Lit.include?(desc_stream[0].klass)
	  @output << "= " + Lit[desc_stream[0].klass] + "\n"
	end

	desc_stream.each do |desc|
	  next if Lit.include?(desc.klass)
	  write1(desc)
	end
      end

      Lit = {
	NilClass => 'nil', 
	TrueClass => 'true',
	FalseClass => 'false'
      }

      def write1(desc)
	head(desc)
	body(desc)
	attr(desc)
	ivar(desc)
	@output << "\n"
      end

      def link(desc)
	"((<#{name(desc)}>))"
      end

      def name(desc)
	@map[desc.__id__]
      end
      
      def head(desc)
	@output << "= #{name(desc)}\n"
	@output << desc.klass.name + "\n"
      end

      def body(desc)
	return if desc.body.size == 0
	  
	desc.body.each do |v|
	  @output << "*#{value(v)}\n"
	end
      end

      def attr(desc)
	return if desc.attr.size == 0

	desc.attr.each do |k, v|
	  @output << ":#{k.to_s}\n"
	  @output << "  #{value(v)}\n"
	end
      end

      def ivar(desc)
	return if desc.ivars.size == 0

	desc.ivars.each do |k, v|
	  @output << ":#{k.to_s}\n"
	  @output << "  #{value(v)}\n"
	end
      end

      def value(obj)
	case obj
	when *Lit
	  Lit[obj.class]
	when ABLoad::Desc
	  if Lit.include?(obj.klass)
	    Lit[obj.klass]
	  else
	    "((<" + name(obj).to_s + ">))"
	  end
	when String
	  obj.dump
	when Float
	  obj.to_s
	when Integer
	  obj.to_s
	end
      end
    end

    class Reader
      def initialize
	@map = {}
	@desc = nil
	@stream = []
	@sts = self.method(:feed_head)
	@key = nil
	@lit = {}
      end
      attr_reader :stream
      
      def read(src)
	src.each do |ln|
	  ln.chomp!
	  @sts.call(ln)
	end
	@stream[0]
      end

      def feed_head(line)
	return true if feed_special(line)
	if /^=\s*(\d+)\s*$/ =~ line
	  num = $1.to_i
	  @desc = desc_ref(num)
	  @stream.push(@desc)
	  @sts = self.method(:feed_class)
	  true
	else
	  false
	end
      end

      def feed_special(line)
	return false unless  /^=\s*(\S+)\s*$/ =~ line
	case $1
	when 'nil'
	  @desc = desc_class(NilClass)
	when 'false'
	  @desc = desc_class(FalseClass)
	when 'true'
	  @desc = desc_class(TrueClass)
	else
	  return false
	end
	@stream.push(@desc)
	@sts = self.method(:feed_head)
	true
      end
      
      def feed_class(line)
	if /^(\S+)/ =~ line
	  @desc.klass = str_to_class($1)
	  @sts = self.method(:feed_body_attr)
	  true
	else
	  false
	end
      end
      
      def feed_body_attr(line)
	return true if feed_head(line)
	return true if feed_attr_key(line)
	if /^\*\s*(.+)$/ =~line
	  @desc.push_body(value($1))
	  true
	else
	  false
	end
      end

      def feed_attr_key(line)
	if /^:\s*(\S+)/ =~ line
	  @attr_key = $1
	  @sts = self.method(:feed_attr_desc)
	  true
	else
	  false
	end
      end

      def feed_attr_desc(line)
	return false if line.empty?
	if /^\s+(.+)/ =~ line
	  val = value($1)
	  if /^@/ =~ @attr_key
	    raise("ivar's value must be Desc") unless val.class == ABLoad::Desc
	    @desc.ivars[@attr_key.intern] = val
	  else
	    @desc.put_attr(@attr_key.intern, val)
	  end
	  @attr_key = nil
	  @sts = method(:feed_body_attr)
	  true
	else
	  raise('AttrDescNotFound')
	end
      end

      def value(str)
	str = str.strip
	case str
	when 'nil'
	  desc_class(NilClass)
	when 'false'
	  desc_class(FalseClass)
	when 'true'
	  desc_class(TrueClass)
	when /^\(\(\<(\d+)\>\)\)/
	  desc_ref($1.to_i)
	else
	  safe_eval(str) #FIXME
	end
      end

      def desc_ref(num)
	unless @map.include?(num)
	  @map[num] = ABLoad::Desc.new
	end
	return @map[num] 
      end

      def desc_class(klass)
	unless @map.include?(klass)
	  desc = ABLoad::Desc.new
	  @map[klass] = desc
	  @stream.push(desc)
	  desc.klass= klass
	end
	return @map[klass]
      end

      def safe_eval(str)
	th = Thread.start { $SAFE=4; eval(str) }
	th.value
      end

      def str_to_class(str)
	ary = str.split('::')
	mod = Kernel
	str.split('::').each do |nm|
	  mod = mod.const_get(nm)
	end
	mod
      end
    end
  end
end
