# REF: akr's AMarshal

module ABLoad
  class MarshalFormatter
    TYPE_NIL	= ?0
    TYPE_TRUE	= ?T
    TYPE_FALSE	= ?F
    TYPE_FIXNUM	= ?i

    TYPE_UCLASS	= ?C
    TYPE_OBJECT	= ?o
    TYPE_USERDEF	= ?u
    TYPE_FLOAT	= ?f
    TYPE_BIGNUM	= ?l
    TYPE_STRING	= ?"	# "
    TYPE_REGEXP	= ?/ 
    TYPE_ARRAY	= ?[
    TYPE_HASH	= ?{
    TYPE_HASH_DEF	= ?}
    TYPE_STRUCT	= ?S
    TYPE_MODULE_OLD	= ?M
    TYPE_CLASS	= ?c
    TYPE_MODULE	= ?m
    TYPE_SYMBOL	= ?:
    TYPE_SYMLINK	= ?;
    TYPE_IVAR	= ?I
    TYPE_LINK	= ?@

    I32 = (-0x80000000)..(0x7fffffff)

    def initialize(major=4, minor=5)
      @symbol = {}
      @map = {}
      @buf = ''
      @major = major
      @minor = minor
      byte(major)
      byte(minor)
    end

    def dump(ref)
      object(ref)
    end

    def result
      return @buf
    end

    def byte(d)
      @buf << [d].pack('C')
    end

    def long(d)
      raise TypeError.new("long too big to dump: #{d}") if d < -0x80000000 || 0x7fffffff < d
      if d == 0
	byte(0)
      elsif 0 < d && d < 123
	byte(d + 5)
      elsif -124 < d && d < 0
	byte((d - 5) & 0xff)
      else
	buf = []
	begin
	  buf << (d & 0xff)
	  d >>= 8
	end until d == 0 || d == -1
	byte(buf.length)
	buf.each {|b| byte(b)}
      end
    end

    def bignum(d)
      #FIXME
      #ȴ
      s = Marshal.dump(d.to_i)
      @buf << s[2..-1]
    end

    def time(sec, usec)
      #FIXME
      #ȴ
      s = Marshal.dump(Time.at(sec, usec))
      @buf << s[2..-1]
    end

    def symbol(name)
      num = @symbol[name]
      if num
	byte(TYPE_SYMLINK)
	long(num)
      else
	byte(TYPE_SYMBOL)
	bytes_str(name)
	@symbol[name] = @symbol.size
      end
    end

    def unique(name)
      symbol(name)
    end

    def float(f)
      bytes_str(sprintf("%.16g", f))
    end

    def bytes_str(d)
      long(d.length)
      @buf << d
    end

    def uclass(c, klass)
      if c != klass
	byte(TYPE_UCLASS)
	byte(TYPE_SYMBOL)
	bytes_str(c.name)
      end
    end

    def ivar(hash)
      if hash
	long(hash.size)
	hash.each do |k, v|
	  symbol(k.id2name)
	  object(v)
	end
      else
	long(0)
      end
    end

    def generic_ivars(r)
      klass = r.klass

      return nil unless (r.ivars && r.ivars.size > 0)

      if Class >= klass
      elsif Module >= klass
      elsif Float >= klass
      elsif Bignum >= klass
      elsif String >= klass
      elsif Regexp >= klass
      elsif Array >= klass
      elsif Hash >= klass
      elsif Struct >= klass
      elsif Object >= klass
	return nil
      end

      return r.ivars
    end

    def userdef(r)
      byte(TYPE_USERDEF)
      unique(r.class.to_s)
      byte @major
      byte @minor
      byte TYPE_ARRAY
      long(5)
      object(r.klass)
      object(r.body)
      object(r.attr)
      object(r.ivars)
      # object(custom_loader)
    end

    def object(r, klass=nil)
      klass = r.klass unless klass
      if klass == NilClass
	byte TYPE_NIL
      elsif klass == TrueClass
	byte TYPE_TRUE
      elsif klass == FalseClass
	byte TYPE_FALSE
      elsif klass == Fixnum 
	if I32 === r.body[0]
	  byte TYPE_FIXNUM
	  long(r.body[0])
	else
	  object(r, Bignum)
	end
      elsif klass == Time
	time(r.attr[:sec], r.attr[:usec])
      elsif klass == Symbol
	symbol(r.body[0])
      else
	if @map[r.object_id]
	  byte(TYPE_LINK)
	  long(@map[r.object_id])
	  return
	end

	@map[r.object_id] = @map.size
	#if r.custom_loader 
	# userdef(r)
	# marshal.cޥȽʣȤƤ館ʤ
	# ޤ
        #end

	ivars = generic_ivars(r)	#MAGIC

	if Class >= klass
	  byte(TYPE_CLASS)
	  bytes_str(r.body[0])
	elsif Module >= klass
	  byte(TYPE_MODULE)
	  bytes_str(r.body[0])
	elsif Float >= klass
	  byte(TYPE_FLOAT)
	  float r.body[0]
	elsif Bignum >= klass
	  # class #bignumǽ񤤤Ƥ
	  bignum r.body[0]
	elsif String >= klass
	  uclass(klass, String)
	  byte(TYPE_STRING)
	  bytes_str(r.body[0])
	elsif Regexp >= klass
	  uclass(klass, Regexp)
	  byte(TYPE_REGEXP)
	  bytes_str(r.attr[:source] || '')
	  byte(r.attr[:options] || 0)
	elsif Array >= klass
	  uclass(klass, Array)
	  byte(TYPE_ARRAY)
	  len = r.body.size
	  long(len)
	  r.body.each do |e|
	    object(e)
	  end
	elsif Hash >= klass
	  uclass(klass, Hash)
	  ifnone = r.attr[:default]
	  byte(ifnone ? TYPE_HASH_DEF : TYPE_HASH)
	  len = r.body.size / 2
	  long(len)
	  len.times do |idx|
	    object(r.body[idx * 2])
	    object(r.body[idx * 2 + 1])
	  end
	  object(ifnone) if ifnone
	elsif Struct >= klass
	  byte(TYPE_STRUCT)
	  len = r.body.size / 2
	  unique(klass.name)
	  long(len)
	  len.times do |idx|
	    symbol(r.body[idx * 2])
	    object(r.body[idx * 2 + 1])
	  end
	elsif Range >= klass
	  byte(TYPE_OBJECT)
	  unique(klass.name)
	  ivar( {:end =>r.attr[:end], 
		 :begin =>r.attr[:begin], 
		 :excl =>r.attr[:excl]} )
	elsif Exception >= klass
	  byte(TYPE_OBJECT)
	  unique(klass.name)
	  hash = r.ivars.dup
	  hash[:mesg] = r.attr[:message]
	  hash[:bt] = r.attr[:backtrace]
	  ivar(hash)
	elsif Object >= klass
	  byte(TYPE_OBJECT)
	  unique(klass.name)
	  ivar(r.ivars)
	else
	  raise TypeError, "can't dump #{klass}"
	end
	ivar(ivars) if ivars #MAGIC
      end
    end
  end
end
